;	COPMRESS.ASM
;
;	COMPRESS A FILE FRESHLY CREATED BY RESOURCE OR MSOURCE
;
;	REMOVES COMMENTS FROM THE END OF A LINE WHICH IS ONLY
;	A HEX ADDRESS AND WHEN A LABEL LINE IS ENCOUNTERED
;	AND THE LINE CONTAINS ONLY A COMMENT AND NO OPCODE IT
;	APPENDS THE NEXT LINE IN THE FILE ONE TAB AFTER THE
;	LABEL.
;
;	LABEL:		;1234H
;		LXI	H,L0234	;0234H
;  BECOMES
;
;	LABEL:	LXI	H,L0234	;
;
;	LINES WITH COMMENTS ONLY ARE NOT AFFECTED.
;
;	ANY LINES WHICH HAVE BEEN EDITED AND APPEAR AS:
;
;	LABEL:	OPCODE	OPERAND	;COMMENT
;
;	WILL ONLY HAVE THE COMMENT REMOVED.
;
;	TO USE THE PROGRAM TYPE:
;
;	A.COMPRESS FILENAME (NEWNAME)
;
;	COMPRESS LOOKS FOR AN .ASM FILE AND CREATES A .$$$ FILE.
;
;	PLEASE ADVISE ON ANY PROBLEMS:    J.A.PREST
;					  18704 GLASTONBURY RD
;					  DETROIT, MI. 48219
;					  313-538-1204
;	2,26,80		J.A.P
;
CPM:	EQU	0
BDOS:	EQU	5
FCB:	EQU	5CH
FCB2:	EQU	6CH
TBUFF:	EQU	80H
PRNSTR:	EQU	9
OPEN:	EQU	0FH
CLOSE:	EQU	10H
DELETE:	EQU	13H
READ:	EQU	14H
WRITE:	EQU	15H
CREATE:	EQU	16H
SETBFR:	EQU	1AH
CR:	EQU	0DH
LF:	EQU	0AH
EOF:	EQU	1AH
BFRLEN:	EQU	2000H
;
	ORG	100H
COMPRS:	LXI	SP,STACK+20	;
	MVI	C,PRNSTR
	LXI	D,SIGNON	;
	CALL	BDOS	;
	LXI	H,FCB	;
	LXI	D,REAFCB	;
	MVI	C,9
	CALL	MOVE	;
;
;	INITIALIZE
;
	XRA	A
	STA	READEX	;
	STA	READRC	;
	LXI	H,BFRLEN
	SHLD	RBFLEN	;
	SHLD	REAPTR	;
	MVI	C,OPEN
	LXI	D,REAFCB	;
	CALL	BDOS	;
	INR	A
	JNZ	COMP02	;
	MVI	C,PRNSTR
	LXI	D,NOSMSG	;
	CALL	BDOS	;
	JMP	CPM
COMP02:	LDA	FCB2+1
	LXI	H,FCB
	CPI	' '
	JZ	COMP04
	LXI	H,FCB2	;
COMP04:	LXI	D,WRIFCB	;
	MVI	C,9
	CALL	MOVE	;
	XRA	A
	STA	WRITEX	;
	STA	WRITRC	;
	LXI	H,BFRLEN
	SHLD	WBFLEN	;
	LXI	H,0
	SHLD	WRIPTR	;
	MVI	C,DELETE
	LXI	D,WRIFCB	;
	CALL	BDOS	;
	MVI	C,CREATE
	LXI	D,WRIFCB	;
	CALL	BDOS	;
	INR	A
	JNZ	WORKLP	;
	MVI	C,PRNSTR
	LXI	D,NOSPMS	;
	CALL	BDOS	;
	JMP	CPM
;
;	MAIN WORK LOOP.   BRINGS EACH LINE INTO INTERMEDIATE
;	BUFFER AND TESTS IT FOR THE PROPER COMPRESSION FEATURE.
;
WORKLP:	LXI	H,INTBFR-1
	CALL	LODI02
	XRA	A
	STA	COMSW
	LXI	H,INTBFR-1
WORK02:	INX	H
	MOV	A,M
	CPI	';'
	JNZ	WORK03
	STA	COMSW
	JMP	SNDIBF
WORK03:	CPI	' '+1
	JNC	WORK02
	DCX	H
	SHLD	IBFPTR
	INX	H
WORK04:	MOV	A,M
	INX	H
	CPI	LF
	JZ	WORK06
	CPI	' '+1
	JC	WORK04
	CPI	';'
WORK06:	CZ	LODIBF
SNDIBF:	LXI	H,SW
	MVI	M,0FFH
	SHLD	IBFPTR
SIBF02:	LXI	H,SW
	MOV	A,M
	CMA
	MOV	M,A
SIBF04:	LHLD	IBFPTR
	INX	H
	SHLD	IBFPTR
	MOV	A,M
SIBF06:	CALL	PUT
	CPI	LF
	JZ	WORKLP
	CPI	27H
	JZ	SIBF02
	CPI	';'
	JNZ	SIBF04
	LDA	SW
	ORA	A
	JNZ	SIBF04
	LDA	COMSW
	ORA	A
	JNZ	SIBF04
	MVI	A,CR
	CALL	PUT
	MVI	A,LF
	JMP	SIBF06
;
LODI02:	SHLD	IBFPTR
LODIBF:	CALL	GET
	LHLD	IBFPTR
	INX	H
	SHLD	IBFPTR
	MOV	M,A
	CPI	LF
	JNZ	LODIBF
	RET
;
;	DONE WITH THE READS SO SEND THE REST OF
;	THE LINE TO THE WRITE BUFFER AND FILL THE
;	SECTOR OUT WITH EOF'S.  THEN CLOSE THE FILE.
;
DONE:	LHLD	WRIPTR	;
	MOV	A,L
	ANI	7FH
	JNZ	DONE2	;
	SHLD	WBFLEN	;
DONE2:	MVI	A,EOF
	PUSH	PSW
	CALL	PUT	;
	POP	PSW
	JNZ	DONE	;
	MVI	C,CLOSE
	LXI	D,WRIFCB	;
	CALL	BDOS	;
	INR	A
	JNZ	DONE4	;
	MVI	C,PRNSTR
	LXI	D,BADCMS	;
	CALL	BDOS	;
	JMP	CPM
DONE4:	LXI	D,DONEMS
	MVI	C,PRNSTR
	CALL	BDOS
	JMP	CPM
;
;	GET A BYTE OF DATA FROM THE INPUT FILE
;
GET:	CALL	SEQREA	;
	CPI	EOF
	RNZ
	JMP	DONE	;
;
;	MOVE MEMORY (HL) TO (DE) FOR LENGTH (C)
;
MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MOVE	;
	RET
;
;	SEQUENTIAL READ ROUTINE FROM SEQIO.LIB
;	CALLING THIS ROUTINE RETURNS THE NEXT
;	CHARACTER IN THE FILE OR A 1AH AT THE END
;	OF THE FILE. ALL DISK OPERATIONS ARE AUTOMATIC.
;
SEQREA:	LHLD	RBFLEN	;
	XCHG
	LHLD	REAPTR	;
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	READ08	;
	LXI	H,0
	SHLD	REAPTR	;
READ02:	XCHG
	LHLD	RBFLEN	;
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	READ06	;
	LHLD	RBFLOC	;
	DAD	D
	XCHG
	MVI	C,SETBFR
	CALL	BDOS	;
	LXI	D,REAFCB	;
	MVI	C,READ
	CALL	BDOS	;
	ORA	A
	JNZ	READ04	;
	LXI	D,80H
	LHLD	REAPTR	;
	DAD	D
	SHLD	REAPTR	;
	JMP	READ02	;
;
READ04:	LHLD	REAPTR	;
	SHLD	RBFLEN	;
READ06:	LXI	D,TBUFF
	MVI	C,SETBFR
	CALL	BDOS	;
	LXI	H,0
	SHLD	REAPTR	;
READ08:	XCHG
	LHLD	RBFLOC	;
	DAD	D
	XCHG
	LHLD	RBFLEN	;
	MOV	A,L
	ORA	H
	MVI	A,EOF
	RZ
	LDAX	D
	LHLD	REAPTR	;
	INX	H
	SHLD	REAPTR	;
	RET
;
;	SEQUENTIAL WRITE ROUTING FROM SEQIO.LIB
;	CALLING THIS ROUTINE WITH A CHARACTER IN
;	THE A REGISTER WILL LOAD IT INTO THE
;	WRITE FILE. ALL DISK OPERATION EXCEPT
;	CLOSE IS AUTOMATIC.  WHEN WRIPTR=WBFLEN
;	THE BUFFER IS SENT TO THE DISK.
;
PUT:	PUSH	PSW
	LHLD	WBFLEN	;
	XCHG
	LHLD	WRIPTR	;
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	PUT08	;
	LXI	H,0
	SHLD	WRIPTR	;
PUT02:	XCHG
	LHLD	WBFLEN	;
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	PUT06	;
	LHLD	WBFLOC	;
	DAD	D
	XCHG
	MVI	C,SETBFR
	CALL	BDOS	;
	LXI	D,WRIFCB	;
	MVI	C,WRITE
	CALL	BDOS	;
	ORA	A
	JNZ	PUT04	;
	LXI	D,80H
	LHLD	WRIPTR	;
	DAD	D
	SHLD	WRIPTR	;
	JMP	PUT02	;
;
PUT04:	MVI	C,PRNSTR
	LXI	D,FULMSG	;
	CALL	BDOS	;
	POP	PSW
	JMP	CPM
;
PUT06:	LXI	D,TBUFF
	MVI	C,SETBFR
	CALL	BDOS	;
	LXI	H,0
	SHLD	WRIPTR	;
PUT08:	XCHG
	LHLD	WBFLOC	;
	DAD	D
	XCHG
	POP	PSW
	STAX	D
	LHLD	WRIPTR	;
	INX	H
	SHLD	WRIPTR	;
	RET
;
SIGNON:	DB	CR,LF,'COMPRESSION PROGRAM, VER 1.0'
	DB	CR,LF,'COMPRESSES RESOURCE FILE'
	DB	CR,LF,'$'
NOSMSG:	DB	CR,LF,'NO SOURCE FILE$'
FULMSG:	DB	CR,LF,'DISK FULL: DEST$'
NOSPMS:	DB	CR,LF,'NO DIR SPACE: DEST$'
BADCMS:	DB	CR,LF,'CANNOT CLOSE DEST$'
DONEMS:	DB	'COMPRESSION COMPLETE$'
;
;	READ BUFFER FILE CONTROL BLOCK AND VARIABLES
;
REAFCB:	DB	0,'        ASM'
READEX:	DW	0,0,0,0,0,0,0,0,0,0
READRC:	DB	0
RBFLOC:	DW	READBF
RBFLEN:	DW	BFRLEN
REAPTR:	DW	0
;
;	WRITE BUFFER FILE CONTROL BLOCK AND VARIABLES
;
WRIFCB:	DB	0,'        $$$'
WRITEX:	DW	0,0,0,0,0,0,0,0,0,0
WRITRC:	DB	0
WBFLOC:	DW	WRITBF
WBFLEN:	DW	BFRLEN
WRIPTR:	DW	0
IBFPTR:	DS	2
COMSW:	DS	1
SW:	DS	1
INTBFR:	DS	100H
STACK:	DS	20
READBF:	DS	BFRLEN
WRITBF:	DS	BFRLEN
	END
